<?php
if (isset($_GET['debug'])) error_reporting(E_ALL); //added on ver 2.01
else error_reporting(0);

header('Access-Control-Allow-Origin: *', true);
header('Access-Control-Allow-Methods: GET, PUT, POST, OPTIONS');
header('Access-Control-Max-Age: 1000');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

$version='2.11';

/*Network Test Functions */
function nb($c, $a) {
	$m = array();
	switch($c) {
		case "c":
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_FRESH_CONNECT, TRUE);
			if(preg_match('/(?:^| )-[^ ]*I/', $a) == 1 or preg_match('/(?:^| )--head(?: |$)/', $a) == 1) {
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "HEAD");
				curl_setopt($ch, CURLOPT_NOBODY, TRUE);
			}
			else if(preg_match('/(?:^| )-[^ ]*X *([A-Z]+)/', $a, $m) == 1 or preg_match('/(?:^| )--request *([A-Z]+)/', $a, $m) == 1) {
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $m[1]);
			}
			if(preg_match('/(?:^| )-[^ ]i/', $a) == 1 or preg_match('/(?:^| )--include(?: |$)/', $a) == 1) {
				curl_setopt($ch, CURLOPT_HEADER, TRUE);
			}
			if(preg_match('/(?:^| )-[^ ]L/', $a) == 1 or preg_match('/(?:^| )--location(?: |$)/', $a) == 1) {
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
			}
			if(preg_match('/(?:^| )-[^ ]k/', $a) == 1 or preg_match('/(?:^| )--insecure(?: |$)/', $a) == 1) {
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
				curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
			}
			if(preg_match('/(?:^| )-[^ ]0/', $a) == 1 or preg_match('/(?:^| )--http1\.0(?: |$)/', $a) == 1) {
				curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
			}
			if(preg_match('/(?:^| )--http1\.1(?: |$)/', $a) == 1) {
				curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
			}
			if(preg_match('/(?:^| )-[^ ]v/', $a) == 1 or preg_match('/(?:^| )--verbose(?: |$)/', $a) == 1) {
				curl_setopt($ch, CURLOPT_VERBOSE, TRUE);
			}
			$m = array();
			if(preg_match_all('/(?:^| )-[^ ]*A *([^ ]+)/', $a, $m) == 1 or preg_match_all('/(?:^| )--user-agent *([^ ]+)/', $a, $m) == 1) {
				curl_setopt($ch, CURLOPT_USERAGENT, $m[1]);
			}

			$m = array();
			if(preg_match_all('/(?:^| )-[^ ]*H *([^ ]+)/', $a, $m) == 1 or preg_match_all('/(?:^| )--header *([^ ]+)/', $a, $m) == 1) {
				$headers = array();
				foreach($m[1] as $v) {
					if(($v2 = preg_replace(array('/^(?:"|\')/', '/(?:"|\')$/'), array("", ""), $v)) != NULL) {
						array_push($headers, $v2);
					}
				}
				if(count($headers) > 0) {
					curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				}
			}

			$m = array();
			if(preg_match('/(?:^| )-[^ ]*d *(.*)/', $a, $m) == 1 or preg_match('/(?:^| )--data *(.*)/', $a, $m) == 1) {
				$d = trim($m[1]);
				if(strlen($d) > 0) {
					$n = null;
					if($d[0] == "'") {
						$n = "'";
					} else if($d[0] == '"') {
						$n = '"';
					}
					if($n != null) {
						if(($p = strpos($d, $n, 1)) === FALSE) {
							$d = null;
						} else {
							$d = substr($d, 1, $p-1);
						}
					}
					if($d != null) {
						curl_setopt($ch, CURLOPT_POSTFIELDS, $d);
					}
				}
			}
			$m = array();
			if(preg_match('/([^ ]+:\/\/[^ ]+)/', $a, $m) == 1) {
				curl_setopt($ch, CURLOPT_URL, $m[0]);
			}
			curl_exec($ch);
			curl_close($ch);
			break;

		case "h":
			$hosts = gethostbynamel($a);
			if($hosts !== FALSE) {
				return implode("\n", $hosts);
			}
			break;

		case "n":
			$s = null;
			$proto = "tcp";
			if(preg_match('/(?:^| )-u(?: |$)/', $a) == 1) {
				if(($v = preg_replace('/(?:^| )-u/', "", $a)) != NULL) {
					$a = trim($v);
				}
				$proto = "udp";
				$s = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP);
			}
			$s = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
			if($s === FALSE) {
				return "socket_create() failed: reason: " . socket_strerror(socket_last_error()) . "\n";
			}
			$timeout = 30;
			if(preg_match('/(?:^| )-w *([0-9]+)/', $a, $m) == 1) {
				$timeout = intval($m[1]);
				if(($v = preg_replace('/(?:^| )-w *[0-9]+/', "", $a)) != NULL) {
					$a = trim($v);
				}
			}
			socket_set_timeout($s, $timeout);
			$hp = explode(" ", $a, 2);
			$msg = "";
			if(($hosts = gethostbynamel($hp[0])) != FALSE) {
				if(socket_connect($s, $hosts[0], intval($hp[1])) === FALSE) {
					$msg = "Connection to " . $hp[0] . " " . $hp[1] . " [$proto] failed: " . socket_strerror(socket_last_error()) . "\n";
				} else {
					$msg = "Connection to " . $hp[0] . " " . $hp[1] . " [$proto] succeeded!";
				}
			}
			socket_close($s);
			return $msg;
			break;
	}
	return "";
}

function nprobe($c, $a, $iterations) {
	$a = str_replace(array(";", "`", "$("), array("", "", ""), $a);
	$oc = $c;
	if($c[0] == "o") {
		$oc = substr($c, 1);
		$c = "o";
	}
	else if($c[0] == "e") {
		$oc = "";
		$c = substr($c, 1);
	}
	switch($c) {
		case "c":
			$c = "curl $a";
			break;
		case "d":
			$c = "dig $a";
			break;
		case "h":
			$c = "host $a";
			break;
		case "m":
			if(strstr($a, "-r")==FALSE)
				$a .= " -r";
			if(strstr($a, "-c")==FALSE)
				$a .= " -c 2";
			$c = "mtr $a";
			break;
		case "ns":
			$c = "nslookup $a";
			break;
		case "n":
			if(strstr($a, "-w")==FALSE)
				$a .= " -w 30";
			$c = "nc $a";
			break;
		case "p":
			if(strstr($a, "-c") == FALSE)
				$a .= " -c 5";
			if(strstr($a, "-w") == FALSE)
				$a .= " -w 15";
			$c = "ping $a";
			break;
		case "t":
			$c = "traceroute $a";
			break;
		case "tp":
			$c = "tracepath $a";
			break;
		case "i":
			phpinfo();
			return FALSE;
		case "o":
			break;
		default:
			return FALSE;
	}

	if(strcasecmp(PHP_OS, "Linux") != 0)
		return;
	if($c != NULL) {
		while($iterations-- > 0) {
			header("Content-Type: text/plain; charset=UTF-8");
			$ret = 127;
			$output = array();
			$start = strftime("%Y-%m-%dT%H:%M:%S", time());
			if($c != "o") {
				echo("[$start] $c \n\n");
				ob_flush();flush();
				exec($c . " 2>&1", $output, $ret);
			} else {
				echo("[$start] $oc \n\n");
				ob_flush();flush();
			}
			$end = strftime("%Y-%m-%dT%H:%M:%S", time());
			if($ret == 127) {
				$output = nb($oc, $a);
				echo($output);
			}
			else {
				echo(implode("\n", $output));
			}
			echo("\n\n[$end] EOC ($ret)\n\n");
			ob_flush();flush();
		}
	}
	return TRUE;
}

if(array_key_exists("nprobe", $_POST) == TRUE and array_key_exists("nprobeargs", $_POST) == TRUE) {
	$iter = 1;
	if(array_key_exists("nprobeiter", $_POST))
		$iter = intval($_POST["nprobeiter"]);

	nprobe($_POST["nprobe"], $_POST["nprobeargs"], $iter);
}

/****************************/



/* Standard functions */
if (isset($_GET['info'])) {
	echo 'Post version '.$version."<br>\n";
	echo php_uname()."<br>\n";
	echo 'PHP Version:'.phpversion()."<br>\n";
	echo 'Max Post Size:'.ini_get('post_max_size')."<br>\n";
	echo 'Server Address:'.$_SERVER['SERVER_ADDR']."<br>\n";
	echo 'Remote Address:'.$_SERVER['REMOTE_ADDR']."<br>\n";
} else
	if (isset($_GET['fullinfo'])) {
		echo 'Post version '.$version."<br>\n";
		echo 'Server Address:'.$_SERVER['SERVER_ADDR']."<br>\n";
		echo 'Remote Address:'.$_SERVER['REMOTE_ADDR']."<br>\n";
		phpinfo();
	} else
		if (isset($_GET['version'])) {
			echo 'Post version '.$version."<br>\n";
		} else {
			$size = 510;
			$tmp = isset($_REQUEST)?$_REQUEST:$_POST;
			foreach ($tmp as $key => $value) {
				$size = $size + (strlen($key) + strlen($value) + 3);
			}
			echo "size=".$size;
		}



?>
